{******************************************************************************
 ******************************************************************************
 *
 *
 *  EZ-KIT Lite resident monitor
 *
 *  This file is part of the ADSP 2181 EZ-KIT Lite resident monitor.
 *
 *  The monitor is loaded from the on-board EPROM through the BDMA
 *  interface during power up.
 *
 *  The complete source codes include the following files:
 *
 *  INTVEC  .DSP : interrupt vector table
 *  UART    .DSP : UART simulation routine
 *  MAIN    .DSP : main module
 *  SELFTEST.DSP : power up self test routine
 *  UTILITY .DSP : send a line of ASCII text through serial line
 *  COMMAND .DSP : command loop and command interpreter
 *  CODEC   .DSP : 1847 codec initialization and interrupt handling
 *
 *  TONE    .DAT : 32 samples of one complete cycle sine wave
 *  CONSTANT.K   : constants
 *
 *
 ******************************************************************************
 ******************************************************************************}





.module/ram       UTILITY;

.include    <constant.k>;
.entry      sendLine;




{******************************************************************************
 *
 *  Send null terminated string pointed to by i7 and LF/CR.  ASCII is in
 *  lower 8-bit.
 *
 *  REGISTER USAGE SUMMARY:
 *
 *  input  : i7
 *  modyfy : none
 *  output : none
 *  destroy: i7, m7 = 1, l7 = 0, ax1
 *  keep   : none
 *  memory : out_char_ax1
 *  calls  : none
 *
 ******************************************************************************}

sendLine:
        l7 = 0;
        m7 = 1;
again:
        ax1 = dm (i7, m7);
        none = pass ax1;
        if eq jump linefeed;
        call out_char_ax1;
        jump again;

linefeed:
        ax1 = 13;
        call out_char_ax1;
        ax1 = 10;
        call out_char_ax1;
        rts;


.endmod;
