.module       MYEFFECT;

.include <system.k>;
.include <midi.k>;

.global         handle_MIDI_controller;
.external       process_midi;
.external       rx_buf,tx_buf;
.global         main_loop,input_samples,init_params;
.global         irqeisr;

{ signal processing variables here }
.var wavea_res,waveb_res;

.const NUMCOMBYOPS=14;
.var combyops[NUMCOMBYOPS];
.init combyops[ 0]: ^combine_add1,^combine_add2,^combine_add3;
.init combyops[ 3]: ^combine_mul,^combine_and,^combine_or,^combine_xor;
.init combyops[ 7]: ^combine_max1,^combine_max2,^combine_justa,^combine_justb;
.init combyops[11]: ^combine_shift,^combine_addmul,^combine_ringmod;

.var opindex,opfuncptr;
.init opindex:0;
.init opfuncptr:^combine_mul;

{ internal variables }
.var last_input;
.var last_output;
.init last_output:0;

{ parameters here }

{ do any dynamic memory/variable initializing you need to here }
init_params:
        nop;
        nop;
        nop;
        rts;

{ command loop - check for incoming data on serial port }
main_loop:
        ar = dm (CHAR_WAITING_FLAG);    { check serial port for MIDI data }
        none = pass ar;
        if ne jump main_loop;
        call process_midi;        { if MIDI byte received }
        jump main_loop;




{ SPORT0 interrupt handler -- this is called at 44.1KHz }
input_samples:
        ena sec_reg;                { use shadow register bank }

        my0 = dm(rx_buf +1);    { read a/d converters }
        my1 = dm(rx_buf +2);    { leave left/right values in my0,my1 }

        dm(wavea_res) = my0;
        dm(waveb_res) = my1;

        ar  = dm(opfuncptr);
        i4  = ar;
        call(i4);   { returns in mr1; }

        dm(tx_buf+ 1)=mr1;      { write d/a converters }
        dm(tx_buf+ 2)=mr1;      { write left/right values from my0, my1 }

        { save output value (for possible feedback) }
        dm(last_output)=mr1;
        
thatwasfun:
        rti;    



{ combyops! }

combine_add1:  { combine op #0 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x3fff;        { equal mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        rts;

combine_add2:  { combine op #1 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x7fff;        { overdrive mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        if mv sat mr;
        rts;

combine_add3:  { combine op #2 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x7fff;      { overdrive w/ loop distortion mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
	{ eliminate the saturation for loop distortion effect }
        rts;

combine_mul:   { combine op #3 }
        mx0 = dm(wavea_res); { wave A }
        my0 = dm(waveb_res); { wave B }
        mr  = mx0*my0(ss);
        rts;               
        
combine_and:   { combine op #4 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 and ay0;
        mr1 = ar;
        rts;

combine_or:    { combine op #5 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 or  ay0;
        mr1 = ar;
        rts;

combine_xor:   { combine op #6 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 xor ay0;
        mr1 = ar;

        rts;

combine_max1:  { combine op #7 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 - ay0;
        mr1 = ax0;
        if gt rts;
        mr1 = ay0;
        rts;		{ returns the greater one }

combine_max2:  { combine op #8 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 - ay0;
        mr1 = 0;
        if gt rts;

        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x6fff;        { slight overdrive mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        if mv sat mr;

        rts;		{ returns 0 or the sum of the two }

combine_justa:	{ combine op #9 }
	ax0 = dm(wavea_res);
	mr1 = ax0;
	rts;  		{ just returns waveform a }

combine_justb: 	{ combine op #10 }
	ax0 = dm(waveb_res);
	mr1 = ax0;
	rts;  		{ just returns waveform b }

combine_shift:  { combine op #11 }
	ax0 = dm(wavea_res);	
        mr1 = ax0;

	rts;	{ shifts waveform a by the amount in waveform b}

combine_addmul: { combine op #12 }
        mx0 = dm(wavea_res); { wave A }
	my0 = dm(waveb_res); { wave B }
        mx1 = 0x47ff;        { ~1/2 }
	mf  = mx0*my0(ss);
        mr  = mx1 * mf(ss);
	
        mx0 = dm(wavea_res); { wave A }
        my0 = 0x4fff;        { slightly imbalanced equal mixing }
	mr  = mr + mx0*my0(ss);
        mx1 = dm(waveb_res); { wave B }
        my1 = 0x37ff;        { slightly imbalanced equal mixing }
	mr  = mr + mx1*my1(ss);
        if mv sat mr;

	rts;  { returns approx. a/2+b/2+a*b/2 }	

combine_ringmod: { combine op #13 C64 style magnitude flipping }
        ax0 = dm(wavea_res); { wave A }
        ay0 = 0x8000;           { extract sign bit }
        ar  = ax0 and ay0;

        ay0 = dm(waveb_res); { wave B }
        ar  = ax0 xor ay0;   { use wave B, with wave A sign inverting it }
        mr1 = ar;        

        rts;



{ Here is where MIDI messages are used to set variables in your Effect! }
handle_MIDI_controller:
        ax1 = dm(midi_cont);
        ar  = dm(midi_val);
        ay1 = 1;none = ax1-ay1;if eq jump set_blah1;
        ay1 = 127;none = ax1-ay1;if eq jump set_blah127;
        rts;

set_blah1:
        ay1 = dm(midi_val);
        rts;

set_blah127:
        ay1 = dm(midi_val);
        rts;


{ when user presses the white interrupt button }

{ I believe this has a bug whereby the compare flags are
  corrupted when calling this ISR...how to prevent that??? }

.var savear,saveay0,savei0;

irqeisr:
        dm(savear) = ar;
        dm(saveay0) = ay0;
        ar  = i0;
        dm(savei0) = ar;

        ar  = dm(opindex);
        ar  = ar +1;
        dm(opindex) = ar;

        ay0 = NUMCOMBYOPS;
        ar  = ar - ay0;
        if lt jump opindexokay;
        ar  = 0;
        dm(opindex) = ar;

opindexokay:
        ar  = dm(opindex);
        ay0 = ^combyops;
        ar  = ar + ay0;
        i0  = ar;
        ar  = dm(i0,m0);
        dm(opfuncptr) = ar;

        ar  = dm(savei0);
        i0  = ar;
        ay0 = dm(saveay0);
        ar  = dm(savear);

        rti;

.endmod;
